/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class PGmatrix {
    double[][] M;
    int n;
    int p;

    public PGmatrix(int n, int p, double a) {
        double[][] M = new double[n][p];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < p) {
                M[i][j] = a;
                ++j;
            }
            ++i;
        }
        this.n = n;
        this.p = p;
        this.M = M;
    }

    public PGmatrix(double[][] data) {
        int n = data.length;
        int p = data[0].length;
        double[][] M = new double[n][p];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < p) {
                M[i][j] = data[i][j];
                ++j;
            }
            ++i;
        }
        this.n = n;
        this.p = p;
        this.M = M;
    }

    public int[] getDim() {
        int[] dim = new int[]{this.n, this.p};
        return dim;
    }

    public double getEntry(int i, int j) {
        return this.M[i][j];
    }

    public void setEntry(int i, int j, double a) {
        this.M[i][j] = a;
    }

    public void setEntry(int[] li, int[] co, double a) {
        int i = 0;
        while (i < li.length) {
            int j = 0;
            while (j < co.length) {
                if (li[i] >= 0 & co[j] >= 0) {
                    this.M[li[i]][co[j]] = a;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setEntryRow(int i, double[] data) {
        int j = 0;
        while (j < this.p) {
            this.M[i][j] = data[j];
            ++j;
        }
    }

    public void setEntryColumn(int j, double[] data) {
        int i = 0;
        while (i < this.n) {
            this.M[i][j] = data[i];
            ++i;
        }
    }

    public void add(double a) {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.p) {
                double[] dArray = this.M[i];
                int n = j++;
                dArray[n] = dArray[n] + a;
            }
            ++i;
        }
    }

    public PGmatrix plus(PGmatrix m) {
        PGmatrix M = new PGmatrix(this.n, this.p, 0.0);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.p) {
                M.setEntry(i, j, this.M[i][j] + m.getEntry(i, j));
                ++j;
            }
            ++i;
        }
        return M;
    }

    public void multiply(double a) {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.p) {
                double[] dArray = this.M[i];
                int n = j++;
                dArray[n] = dArray[n] * a;
            }
            ++i;
        }
    }

    public PGmatrix times(PGmatrix B) {
        int q = B.getDim()[1];
        double val = 0.0;
        PGmatrix P = new PGmatrix(this.n, q, 0.0);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < q) {
                val = 0.0;
                int k = 0;
                while (k < this.p) {
                    val += this.M[i][k] * B.getEntry(k, j);
                    ++k;
                }
                P.setEntry(i, j, val);
                ++j;
            }
            ++i;
        }
        return P;
    }

    public void setDiag(double[] d) {
        int i = 0;
        while (i < this.n) {
            this.M[i][i] = d[i];
            ++i;
        }
    }

    public double[] getRow(int idx) {
        double[] val = new double[this.p];
        int j = 0;
        while (j < this.p) {
            val[j] = this.M[idx][j];
            ++j;
        }
        return val;
    }

    public double[] getColumn(int idx) {
        double[] val = new double[this.n];
        int i = 0;
        while (i < this.n) {
            val[i] = this.M[i][idx];
            ++i;
        }
        return val;
    }

    public double[] getSum(int id) {
        double[] val;
        double[] def = new double[]{0.0};
        switch (id) {
            case 1: {
                double[] val1 = new double[this.n];
                int i = 0;
                while (i < this.n) {
                    val1[i] = 0.0;
                    int j = 0;
                    while (j < this.n) {
                        int n = i;
                        val1[n] = val1[n] + this.M[i][j];
                        ++j;
                    }
                    ++i;
                }
                val = val1;
                break;
            }
            case 2: {
                double[] val2 = new double[this.p];
                int j = 0;
                while (j < this.p) {
                    val2[j] = 0.0;
                    int i = 0;
                    while (i < this.n) {
                        int n = j;
                        val2[n] = val2[n] + this.M[i][j];
                        ++i;
                    }
                    ++j;
                }
                val = val2;
                break;
            }
            default: {
                val = def;
            }
        }
        return val;
    }

    public PGmatrix getSubMatrix(int[] li, int[] co) {
        int q = li.length;
        int r = co.length;
        double[][] data = new double[q][r];
        int i = 0;
        while (i < q) {
            int j = 0;
            while (j < r) {
                data[i][j] = this.M[li[i]][co[j]];
                ++j;
            }
            ++i;
        }
        PGmatrix P = new PGmatrix(data);
        return P;
    }

    public void show() {
        int i = 0;
        while (i < this.n) {
            System.out.format("[%2d]", i + 1);
            int j = 0;
            while (j < this.p) {
                System.out.format("%10.6f", this.M[i][j]);
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    public void save(String filename, String[] header) {
        PrintStream output;
        try {
            output = new PrintStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            output = System.out;
        }
        System.setOut(output);
        int i = 0;
        while (i < header.length) {
            System.out.println(header[i]);
            ++i;
        }
        this.show();
        output.close();
        System.setOut(System.out);
    }
}

