/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;

public class Principal {
    static int[] defaultLab = new int[]{3, 8, 12, 13, 14, 17, 18, 19, 23};
    static int defaultSourisLoc = 3;
    static int defaultFromageLoc = 23;
    static int defaultDuration = 20;
    static int defaultNbSimul = 1000;
    static PGmatrix ContigMatrix = new PGmatrix(25, 25, 0.0);
    static int[] StateVector = new int[25];
    static PGmatrix TransMatrix;
    static int[] Lab;
    static int SourisLoc;
    static int FromageLoc;
    static int Duration;
    static int NbSimul;
    static int[] Markov;
    static PGmatrix MarkovProbaTab;
    static int[][] MarkovChainTab;
    static int rv;
    static double[] prob;
    static PGmatrix prob0;
    static PGmatrix prob1;
    static Fenetre fenetre;

    static {
        Lab = (int[])defaultLab.clone();
        SourisLoc = defaultSourisLoc;
        FromageLoc = defaultFromageLoc;
        Duration = defaultDuration;
        NbSimul = defaultNbSimul;
        Markov = new int[50];
        prob = new double[25];
        prob0 = new PGmatrix(1, 25, 0.0);
        prob1 = new PGmatrix(1, 25, 0.0);
    }

    public static void main(String[] args) {
        Fenetre fenetre = new Fenetre(defaultLab, defaultSourisLoc, defaultFromageLoc, defaultDuration, defaultNbSimul);
        fenetre.setVisible(true);
        Principal.initContigMatrix();
    }

    public static void initContigMatrix() {
        int[] li = new int[1];
        int[] co = new int[4];
        li[0] = 0;
        co[0] = -1;
        co[1] = -1;
        co[2] = 1;
        co[3] = 5;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 1;
        co[0] = -1;
        co[1] = 0;
        co[2] = 2;
        co[3] = 6;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 2;
        co[0] = -1;
        co[1] = 1;
        co[2] = 3;
        co[3] = 7;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 3;
        co[0] = -1;
        co[1] = 2;
        co[2] = 4;
        co[3] = 8;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 4;
        co[0] = -1;
        co[1] = 3;
        co[2] = -1;
        co[3] = 9;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 5;
        co[0] = 0;
        co[1] = -1;
        co[2] = 6;
        co[3] = 10;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 6;
        co[0] = 1;
        co[1] = 5;
        co[2] = 7;
        co[3] = 11;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 7;
        co[0] = 2;
        co[1] = 6;
        co[2] = 8;
        co[3] = 12;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 8;
        co[0] = 3;
        co[1] = 7;
        co[2] = 9;
        co[3] = 13;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 9;
        co[0] = 4;
        co[1] = 8;
        co[2] = -1;
        co[3] = 14;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 10;
        co[0] = 5;
        co[1] = -1;
        co[2] = 11;
        co[3] = 15;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 11;
        co[0] = 6;
        co[1] = 10;
        co[2] = 12;
        co[3] = 16;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 12;
        co[0] = 7;
        co[1] = 11;
        co[2] = 13;
        co[3] = 17;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 13;
        co[0] = 8;
        co[1] = 12;
        co[2] = 14;
        co[3] = 18;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 14;
        co[0] = 9;
        co[1] = 13;
        co[2] = -1;
        co[3] = 19;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 15;
        co[0] = 10;
        co[1] = -1;
        co[2] = 16;
        co[3] = 20;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 16;
        co[0] = 11;
        co[1] = 15;
        co[2] = 17;
        co[3] = 21;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 17;
        co[0] = 12;
        co[1] = 16;
        co[2] = 18;
        co[3] = 22;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 18;
        co[0] = 13;
        co[1] = 17;
        co[2] = 19;
        co[3] = 23;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 19;
        co[0] = 14;
        co[1] = 18;
        co[2] = -1;
        co[3] = 24;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 20;
        co[0] = 15;
        co[1] = -1;
        co[2] = 21;
        co[3] = -1;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 21;
        co[0] = 16;
        co[1] = 20;
        co[2] = 22;
        co[3] = -1;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 22;
        co[0] = 17;
        co[1] = 21;
        co[2] = 23;
        co[3] = -1;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 23;
        co[0] = 18;
        co[1] = 22;
        co[2] = 24;
        co[3] = -1;
        ContigMatrix.setEntry(li, co, 1.0);
        li[0] = 24;
        co[0] = 19;
        co[1] = 23;
        co[2] = -1;
        co[3] = -1;
        ContigMatrix.setEntry(li, co, 1.0);
    }

    public static void Configurate(int[] lab, int sl, int fl, int du, int ns) {
        Lab = (int[])lab.clone();
        SourisLoc = sl;
        FromageLoc = fl;
        Duration = du;
        NbSimul = ns;
        Markov = new int[Duration];
        MarkovProbaTab = new PGmatrix(Duration, Lab.length, 0.0);
        MarkovChainTab = new int[NbSimul][Duration];
        Principal.CalculStateVector();
        Principal.CalculTransMatrix();
    }

    public static void CalculStateVector() {
        Arrays.fill(StateVector, -1);
        int[] idx = Lab;
        int i = 0;
        while (i < idx.length) {
            Principal.StateVector[Principal.Lab[i] - 1] = i + 1;
            ++i;
        }
    }

    public static void CalculTransMatrix() {
        PGmatrix D = new PGmatrix(Lab.length, Lab.length, 0.0);
        PGmatrix P = new PGmatrix(Lab.length, Lab.length, 0.0);
        int[] idx = (int[])Lab.clone();
        int i = 0;
        while (i < idx.length) {
            int n = i++;
            idx[n] = idx[n] - 1;
        }
        P = ContigMatrix.getSubMatrix(idx, idx);
        i = 0;
        while (i < Lab.length) {
            P.setEntry(StateVector[FromageLoc - 1] - 1, i, 0.0);
            ++i;
        }
        P.setEntry(StateVector[FromageLoc - 1] - 1, StateVector[FromageLoc - 1] - 1, 1.0);
        double[] tot = P.getSum(1);
        i = 0;
        while (i < Lab.length) {
            D.setEntry(i, i, 1.0 / tot[i]);
            ++i;
        }
        TransMatrix = D.times(P);
    }

    public static void CalculMarkovChain() {
        rv = StateVector[SourisLoc - 1];
        int i = 0;
        while (i < Duration) {
            prob = TransMatrix.getRow(rv - 1);
            Principal.RandomDiscreteLaw();
            Principal.Markov[i] = rv;
            ++i;
        }
        i = 0;
        while (i < Duration) {
            Principal.Markov[i] = Lab[Markov[i] - 1];
            ++i;
        }
    }

    public static void CalculMarkovProba() {
        PGmatrix prob0 = new PGmatrix(1, Lab.length, 0.0);
        PGmatrix prob1 = new PGmatrix(1, Lab.length, 0.0);
        prob0.setEntry(0, StateVector[SourisLoc - 1] - 1, 1.0);
        int i = 0;
        while (i < Duration) {
            prob1 = prob0.times(TransMatrix);
            prob = (double[])prob1.getRow(0).clone();
            MarkovProbaTab.setEntryRow(i, prob);
            prob0.setEntryRow(0, prob);
            ++i;
        }
    }

    public static void CalculSimulations() {
        int i = 0;
        while (i < NbSimul) {
            Principal.CalculMarkovChain();
            Principal.MarkovChainTab[i] = (int[])Markov.clone();
            ++i;
        }
    }

    public static void RandomDiscreteLaw() {
        rv = 0;
        double ru = 0.0;
        double[] cumprob = prob;
        int i = 1;
        while (i < prob.length) {
            cumprob[i] = cumprob[i - 1] + prob[i];
            ++i;
        }
        ru = Math.random();
        rv = 0;
        while (ru > cumprob[rv]) {
            ++rv;
        }
        ++rv;
    }

    public static void SaveSimulations(String filename) {
        PrintStream output;
        try {
            output = new PrintStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            output = System.out;
        }
        System.setOut(output);
        String[] header = new String[8];
        header[0] = "Les cases du Labyrinthe sont : " + Arrays.toString(Lab);
        header[1] = "Le nombre de simuations est : " + NbSimul;
        header[2] = "Le nombre de coups est : " + Duration;
        header[3] = "La position de d\u00e9part de la souris est : case " + SourisLoc;
        header[4] = "La position du fromage est : case " + FromageLoc;
        header[5] = " ";
        String text = "";
        int i = 0;
        while (i < Duration + 1) {
            if (i < 10) {
                text = text.concat("[ " + i + "] ");
            }
            if (i > 9) {
                text = text.concat("[" + i + "] ");
            }
            ++i;
        }
        header[6] = text;
        header[7] = " ";
        i = 0;
        while (i < header.length) {
            System.out.println(header[i]);
            ++i;
        }
        i = 0;
        while (i < NbSimul) {
            System.out.format("%3d  ", SourisLoc);
            int j = 0;
            while (j < Duration) {
                System.out.format("%3d  ", MarkovChainTab[i][j]);
                ++j;
            }
            System.out.println(" ");
            ++i;
        }
        output.close();
        System.setOut(System.out);
    }

    public static void SaveMarkovProba(String filename) {
        PrintStream output;
        try {
            output = new PrintStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            output = System.out;
        }
        System.setOut(output);
        String[] header = new String[9];
        header[0] = "Les cases du Labyrinthe sont : " + Arrays.toString(Lab);
        header[1] = "Le nombre de cases est : " + Lab.length;
        header[2] = "Le nombre de coups est : " + Duration;
        header[3] = "La position de d\u00e9part de la souris est : case " + SourisLoc;
        header[4] = "La position du fromage est : case " + FromageLoc;
        header[5] = "Tableau des Probabilit\u00e9s : prob[i,j] = probabilit\u00e9 d'\u00eatre au i-\u00e8me coup dans la case No j ";
        header[6] = " ";
        String text = "     ";
        int i = 0;
        while (i < Lab.length) {
            if (Lab[i] < 10) {
                text = text.concat("   [ " + Lab[i] + "]   ");
            }
            if (Lab[i] > 9) {
                text = text.concat("   [" + Lab[i] + "]   ");
            }
            ++i;
        }
        header[7] = text;
        header[8] = " ";
        MarkovProbaTab.save(filename, header);
    }
}

